//CONTROLLO PROPORZIONALE
#include <TimerOne.h>

const float Tsp= 25;
const float Pel_max= 100;
float Pel= Pel_max;
long t0=0;
float Kp= 180;
// Variabile globale 'volatile' perché modificata in un interrupt
volatile float Tstanza = 20;

void setup() {
  Serial.begin(9600);
  Timer1.initialize(50000); // timer a 50.000 us (50ms)
  Timer1.attachInterrupt(aggiornaVariabile); // funzione collegata al timer
  Serial.println("Controllo T avviato...");
}

void loop() {

// ON-OFF
/*
  if (Tstanza<= Tsp) { Pel= Pel_max; }  // ON
  else 			     { Pel= 0; }        // OFF  
*/

// PROPORZIONALE
  float errore= abs(Tsp - Tstanza);
  if (errore>1) { 
    Pel= Pel_max;  // max. fino a -1°C dal SP
  }
  else {
    Pel= Kp * errore;   // controllo PROP.
  }

  Serial.print(millis()/1000); Serial.print(";"); Serial.println(Tstanza);
  delay(1000);
}

// Funzione richiamata dal timer (ISR - Interrupt Service Routine)
void aggiornaVariabile() {
  Tstanza = CameraTermica(Pel);
}

// Simula la T(°C) in un locale riscaldato con una Pel(watt)
float CameraTermica(float Pel) { // heat input in W (or J/s)
  float U = 5;
  float Ct = 1006; // J/Kg K
  float A = 2; // m2 area for convection
  float massa =0.1 ; // Kg
  float Tamb = 20; // °C
  static float T = Tamb; // °C
  static uint32_t last = 0;
  uint32_t dt = 50; // ms
  // ogni 50ms calcola la temperatura della camera
  if (millis() - last >= dt) {
    last = millis();
    float Qd = U * A * (T-Tamb);
    T = T + (Pel-Qd) * (dt/1000.0) / (massa*Ct) ;
  }
  return T;
}
