#include <TimerOne.h>

// Variabile globale (usiamo 'volatile' perché modificata in un interrupt)
volatile float valoreGlobale = 0;
long t0=0;
float flagSpento= false;

void setup() {
  Serial.begin(9600);

  // Inizializza il timer con un periodo di 100.000 microsecondi (100ms)
  Timer1.initialize(100000); 
  
  // Collega la funzione all'interrupt del timer
  Timer1.attachInterrupt(aggiornaVariabile); 
  
  Serial.println("Timer Hardware avviato.");
}

void loop() {
 
  if (valoreGlobale>=25) {flagSpento= true;}
 
  Serial.print(millis()/1000); Serial.print(" ");
  Serial.println(valoreGlobale);
  
  delay(1000);
}

// Funzione richiamata dal timer (ISR - Interrupt Service Routine)
void aggiornaVariabile() {
  if (flagSpento== false) {valoreGlobale = Boiler(1500);}
  else  {valoreGlobale = Boiler(0);}
}


float Boiler(float Pel) { // heat input in W (or J/s)
  //float U = 1.771 ; // W/m2K thermal convection coefficient for Al passive
  float U = 5;
  float Ct = 4196; // J/Kg K
  float A = 2; // m2 area for convection
  float massa =80 ; // Kg
  float Tamb = 20; // °K
  static float T = 65; // °K
  static uint32_t last = 0;
  uint32_t interval = 100; // ms

  if (millis() - last >= interval) {
    last = millis();
    float Qd = U * A * (T - Tamb);
    Serial.println(Qd);
    T = T + (Pel - Qd) * interval / 1000.0 / massa / Ct ;
  }

  return T;
}
