int pinIn1= 2;
int pinIn2= 3;
// Costanti del sensore NTC 10K
const float B = 3950;
const float R = 10000.0;
const float RT0 = 10000.0;
const float T0 = 298.15;
const float Vcc = 5.0;

//Variables
float Rs, VR, I, Ts, Vs;

void setup() 
{
  pinMode(pinIn1, OUTPUT);  // L298P
  pinMode(pinIn2, OUTPUT);  // L298P
  Serial.begin ( 9600);
}

void loop() 
{
  int btnAvvio= digitalRead(12);

  Vs = analogRead(A0); // 0-1023 tensione sul termistore
  Vs = (5.00 / 1023.00) * Vs; // converto in Volt
  VR = Vcc-Vs; // tensione sulla resistenza R da 10K
  I = VR/R;  // corrente che circola nel sensore Rs
  Rs = Vs/I; // resistenza di Rs (V/I)
  Ts =1/ (log(Rs/ RT0) / B + 1 / T0); //Ts in K
  Ts = Ts - 273.15; // °C
  
  Serial.print("T= ");
  Serial.print(Ts);
  Serial.println(" C");

  if (Ts>=30) {
    Serial.println("Ventola ON");
    digitalWrite(pinIn1,HIGH);
    digitalWrite(pinIn2,LOW);
  }
  else {
    Serial.println("Ventola OFF");
    digitalWrite(pinIn1,LOW);
    digitalWrite(pinIn2,LOW);
  }

  delay( 2000 );
}
