/*
 * Tiny4kOLED - Drivers for SSD1306 controlled dot matrix OLED/PLED 128x32 displays
 *
 * Based on ssd1306xled, re-written and extended by Stephen Denne
 * from 2017-04-25 at https://github.com/datacute/Tiny4kOLED
 *
 */

#include <avr/pgmspace.h>

// Code Page 437 box drawing characters
const uint8_t cp_437_box_drawing_font_bitmap [] PROGMEM = {
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // 175 � » blank (for convenience - not blank in codepage 437
  0x88,0x22,0x44,0x11,0x88,0x22,0x44,0x11, // 176 � ░
  0xAA,0x55,0xAA,0x55,0xAA,0x55,0xAA,0x55, // 177 � ▒
  0x77,0xDD,0xBB,0xEE,0x77,0xDD,0xBB,0xEE, // 178 � ▓
  0x00,0x00,0x00,0xFF,0xFF,0x00,0x00,0x00, // 179 � │
  0x18,0x18,0x18,0xFF,0xFF,0x00,0x00,0x00, // 180 � ┤
  0x24,0x24,0x24,0xFF,0xFF,0x00,0x00,0x00, // 181 � ╡
  0x18,0x18,0xFF,0x00,0x00,0xFF,0x00,0x00, // 182 � ╢
  0x18,0x18,0xF8,0x18,0x18,0xF8,0x00,0x00, // 183 � ╖
  0x24,0x24,0x24,0xFC,0xFC,0x00,0x00,0x00, // 184 � ╕
  0x24,0x24,0xE7,0x00,0x00,0xFF,0x00,0x00, // 185 � ╣
  0x00,0x00,0xFF,0x00,0x00,0xFF,0x00,0x00, // 186 � ║
  0x24,0x24,0xE4,0x04,0x04,0xFC,0x00,0x00, // 187 � ╗
  0x24,0x24,0x27,0x20,0x20,0x3F,0x00,0x00, // 188 � ╝
  0x18,0x18,0x1F,0x18,0x18,0x1F,0x00,0x00, // 189 � ╜
  0x24,0x24,0x24,0x3F,0x3F,0x00,0x00,0x00, // 190 � ╛
  0x18,0x18,0x18,0xF8,0xF8,0x00,0x00,0x00, // 191 � ┐
  0x00,0x00,0x00,0x1F,0x1F,0x18,0x18,0x18, // 192 � └
  0x18,0x18,0x18,0x1F,0x1F,0x18,0x18,0x18, // 193 � ┴
  0x18,0x18,0x18,0xF8,0xF8,0x18,0x18,0x18, // 194 � ┬
  0x00,0x00,0x00,0xFF,0xFF,0x18,0x18,0x18, // 195 � ├
  0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18, // 196 � ─
  0x18,0x18,0x18,0xFF,0xFF,0x18,0x18,0x18, // 197 � ┼
  0x00,0x00,0x00,0xFF,0xFF,0x24,0x24,0x24, // 198 � ╞
  0x00,0x00,0xFF,0x00,0x00,0xFF,0x18,0x18, // 199 � ╟
  0x00,0x00,0x3F,0x20,0x20,0x27,0x24,0x24, // 200 � ╚
  0x00,0x00,0xFC,0x04,0x04,0xE4,0x24,0x24, // 201 � ╔
  0x24,0x24,0x27,0x20,0x20,0x27,0x24,0x24, // 202 � ╩
  0x24,0x24,0xE4,0x04,0x04,0xE4,0x24,0x24, // 203 � ╦
  0x00,0x00,0xFF,0x00,0x00,0xE7,0x24,0x24, // 204 � ╠
  0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24, // 205 � ═
  0x24,0x24,0xE7,0x00,0x00,0xE7,0x24,0x24, // 206 � ╬
  0x24,0x24,0x24,0x27,0x27,0x24,0x24,0x24, // 207 � ╧
  0x18,0x18,0x1F,0x18,0x18,0x1F,0x18,0x18, // 208 � ╨
  0x24,0x24,0x24,0xE4,0xE4,0x24,0x24,0x24, // 209 � ╤
  0x18,0x18,0xF8,0x18,0x18,0xF8,0x18,0x18, // 210 � ╥
  0x00,0x00,0x1F,0x18,0x18,0x1F,0x18,0x18, // 211 � ╙
  0x00,0x00,0x00,0x3F,0x3F,0x24,0x24,0x24, // 212 � ╘
  0x00,0x00,0x00,0xFC,0xFC,0x24,0x24,0x24, // 213 � ╒
  0x00,0x00,0xF8,0x18,0x18,0xF8,0x18,0x18, // 214 � ╓
  0x18,0x18,0xFF,0x00,0x00,0xFF,0x18,0x18, // 215 � ╫
  0x24,0x24,0x24,0xE7,0xE7,0x24,0x24,0x24, // 216 � ╪
  0x18,0x18,0x18,0x1F,0x1F,0x00,0x00,0x00, // 217 � ┘
  0x00,0x00,0x00,0xF8,0xF8,0x18,0x18,0x18, // 218 � ┌
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF, // 219 � █
  0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0, // 220 � ▄
  0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00, // 221 � ▌
  0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF, // 222 � ▐
  0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F  // 223 � ▀
};

const DCfont cp_437_box_drawing_font = {
  (uint8_t *)cp_437_box_drawing_font_bitmap,
  8, // character width in pixels
  1, // character height in pages (8 pixels)
  175,223, // ASCII extents
  0,0,0 // Unused for fixed width fonts
  };

