int pinVentola=11;
int pinAvvio=12;
int pinIn1= 2;
int pinIn2= 3;

const float B = 3950;
const float R = 10000.0;
const float RT0 = 10000.0;
const float T0 = 298.15;
const float Vcc = 5.0;

//Variables
float Rs, VR, I, Ts, Vs;

void setup() 
{
  pinMode(pinIn1, OUTPUT);
  pinMode(pinIn2, OUTPUT);
  pinMode(pinVentola, OUTPUT);
  pinMode(pinAvvio, INPUT_PULLUP);
  Serial.begin ( 9600);
}

void loop() 
{
  int btnAvvio= digitalRead(12);

  Vs = analogRead(A0); // 0-1023 tensione sul termistore
  Vs = (5.00 / 1023.00) * Vs; // converto in Volt
  VR = Vcc - Vs; // tensione sulla resistenza R da 10K
  I = VR/R;
  Rs = Vs/I; // Resistenza di Rs (V/I)
  Ts =1/ (log(Rs/ RT0) / B + 1 / T0); //Ts in K
  Ts = Ts - 273.15; //Conversion to °C
  
  Serial.print("T= ");
  Serial.print(Ts);
  Serial.println(" C");

  if (Ts>=50 || btnAvvio==LOW) {
    Serial.println("Accendo");
    digitalWrite(pinVentola,HIGH);
    digitalWrite(pinIn1,HIGH);
    digitalWrite(pinIn2,LOW);
  }
  else {
    Serial.println("Spengo");
    digitalWrite(pinVentola,LOW);
    digitalWrite(pinIn1,LOW);
    digitalWrite(pinIn2,LOW);
  }

  delay( 2000 );
}
