/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcImplProvider;

public class BcPGPDigestCalculatorProvider
implements PGPDigestCalculatorProvider {
    public PGPDigestCalculator get(final int n) throws PGPException {
        final Digest digest = BcImplProvider.createDigest(n);
        final DigestOutputStream digestOutputStream = new DigestOutputStream(digest);
        return new PGPDigestCalculator(){

            public int getAlgorithm() {
                return n;
            }

            public OutputStream getOutputStream() {
                return digestOutputStream;
            }

            public byte[] getDigest() {
                return digestOutputStream.getDigest();
            }

            public void reset() {
                digest.reset();
            }
        };
    }

    private class DigestOutputStream
    extends OutputStream {
        private Digest dig;

        DigestOutputStream(Digest digest) {
            this.dig = digest;
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.dig.update(byArray, n, n2);
        }

        public void write(byte[] byArray) throws IOException {
            this.dig.update(byArray, 0, byArray.length);
        }

        public void write(int n) throws IOException {
            this.dig.update((byte)n);
        }

        byte[] getDigest() {
            byte[] byArray = new byte[this.dig.getDigestSize()];
            this.dig.doFinal(byArray, 0);
            return byArray;
        }
    }
}

